<?php
// 1. LOGIKA DETEKSI KELAS
$role = $_SESSION['role_admin'];
$kelas_view = ""; // Variabel penampung kelas yang akan ditampilkan

// A. Jika SISWA yang login -> Cari kelasnya otomatis
if ($role == 'Siswa') {
    $nama_siswa = $_SESSION['nama_admin'];
    $q_cari = mysqli_query($koneksi, "SELECT kelas FROM siswa WHERE nama='$nama_siswa'");
    $d_cari = mysqli_fetch_array($q_cari);
    
    if($d_cari){
        $kelas_view = $d_cari['kelas']; // Otomatis set kelasnya (misal: X-A)
    } else {
        echo "<div class='alert alert-danger'>Data kelas siswa tidak ditemukan.</div>";
    }
} 
// B. Jika ADMIN/GURU yang login -> Ambil dari Filter Dropdown
else {
    if (isset($_GET['kelas'])) {
        $kelas_view = $_GET['kelas'];
    }
}
?>

<h3 class="mb-3 fw-bold">Jadwal Pelajaran</h3>

<!-- 2. FORM FILTER (HANYA MUNCUL UNTUK ADMIN & GURU) -->
<?php if ($role != 'Siswa') { ?>
<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <form method="GET" action="dashboard.php">
            <input type="hidden" name="page" value="jadwal">
            <div class="row g-2">
                <div class="col-md-4">
                    <select name="kelas" class="form-select" required>
                        <option value="">-- Pilih Kelas --</option>
                        <option value="X-A" <?= ($kelas_view=='X-A')?'selected':''; ?>>X-A</option>
                        <option value="X-B" <?= ($kelas_view=='X-B')?'selected':''; ?>>X-B</option>
                        <option value="XI-IPA" <?= ($kelas_view=='XI-IPA')?'selected':''; ?>>XI-IPA</option>
                        <option value="XII-IPA" <?= ($kelas_view=='XII-IPA')?'selected':''; ?>>XII-IPA</option>
                        <!-- Tambahkan lainnya -->
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary w-100 fw-bold">Lihat Jadwal</button>
                </div>
            </div>
        </form>
    </div>
</div>
<?php } ?>

<!-- 3. TAMPILAN TABEL JADWAL -->
<?php
// Tampilkan tabel HANYA jika $kelas_view sudah terisi (baik otomatis dari Siswa atau manual dari Admin)
if (!empty($kelas_view)) {
?>

<div class="card border-0 shadow-sm">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h6 class="m-0 fw-bold">
            <i class="bi bi-calendar3 me-2"></i> Jadwal Kelas <?= $kelas_view ?>
        </h6>
        
        <!-- Tombol Tambah (HANYA ADMIN) -->
        <?php if($role == 'Admin') { ?>
            <button class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#mJadwal">
                <i class="bi bi-plus-lg"></i> Tambah Mapel
            </button>
        <?php } ?>
    </div>
    <div class="card-body p-0">
        <table class="table table-hover table-striped mb-0">
            <thead class="table-dark">
                <tr>
                    <th>Hari</th>
                    <th>Jam</th>
                    <th>Mata Pelajaran</th>
                    <th>Guru Pengampu</th>
                    <?php if($role == 'Admin') { ?> <th>Aksi</th> <?php } ?>
                </tr>
            </thead>
            <tbody>
                <?php
                // Urutkan berdasarkan Hari (Senin-Sabtu) dan Jam
                $sql = "SELECT * FROM jadwal 
                        WHERE kelas='$kelas_view' 
                        ORDER BY FIELD(hari, 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'), jam_mulai ASC";
                
                $q = mysqli_query($koneksi, $sql);
                
                if(mysqli_num_rows($q) > 0) {
                    while($d = mysqli_fetch_array($q)){
                ?>
                <tr>
                    <td>
                        <?php 
                            $bg = 'bg-secondary';
                            if($d['hari']=='Senin') $bg='bg-primary';
                            if($d['hari']=='Selasa') $bg='bg-info text-dark';
                            if($d['hari']=='Rabu') $bg='bg-success';
                            if($d['hari']=='Kamis') $bg='bg-warning text-dark';
                            if($d['hari']=='Jumat') $bg='bg-danger';
                        ?>
                        <span class="badge <?= $bg ?>"><?= $d['hari'] ?></span>
                    </td>
                    <td><?= date('H:i', strtotime($d['jam_mulai'])) ?> - <?= date('H:i', strtotime($d['jam_selesai'])) ?></td>
                    <td class="fw-bold"><?= $d['mapel'] ?></td>
                    <td><?= $d['guru'] ?></td>
                    
                    <!-- Tombol Hapus (HANYA ADMIN) -->
                    <?php if($role == 'Admin') { ?>
                        <td>
                            <a href="proses/act_jadwal.php?aksi=hapus&id=<?= $d['id'] ?>&kelas=<?= $kelas_view ?>" class="btn btn-sm btn-danger py-0" onclick="return confirm('Hapus jadwal ini?')">X</a>
                        </td>
                    <?php } ?>
                </tr>
                <?php 
                    } 
                } else {
                    echo "<tr><td colspan='5' class='text-center py-5 text-muted'>
                        <i class='bi bi-calendar-x fs-1'></i><br>Belum ada jadwal untuk kelas ini.
                    </td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Modal Tambah (HANYA ADMIN) -->
<?php if($role == 'Admin') { ?>
<div class="modal fade" id="mJadwal">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="proses/act_jadwal.php">
                <div class="modal-header"><h5>Tambah Jadwal Pelajaran</h5></div>
                <div class="modal-body">
                    <input type="hidden" name="kelas" value="<?= $kelas_view ?>">
                    
                    <div class="mb-2">
                        <label>Hari</label>
                        <select name="hari" class="form-select" required>
                            <option>Senin</option><option>Selasa</option><option>Rabu</option>
                            <option>Kamis</option><option>Jumat</option><option>Sabtu</option>
                        </select>
                    </div>
                    <div class="row mb-2">
                        <div class="col">
                            <label>Jam Mulai</label>
                            <input type="time" name="jam_mulai" class="form-control" required>
                        </div>
                        <div class="col">
                            <label>Jam Selesai</label>
                            <input type="time" name="jam_selesai" class="form-control" required>
                        </div>
                    </div>
                    <div class="mb-2">
                        <label>Mata Pelajaran</label>
                        <input type="text" name="mapel" class="form-control" placeholder="Contoh: Fisika" required>
                    </div>
                    <div class="mb-2">
                        <label>Guru Pengampu</label>
                        <input type="text" name="guru" class="form-control" placeholder="Contoh: Pak Budi" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" name="simpan_jadwal" class="btn btn-success">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php } ?>

<?php } // Penutup IF !empty($kelas_view) ?>